"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EMSVectorTileStyleEditor = EMSVectorTileStyleEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/ems/components/ems_vector_tile_style_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function EMSVectorTileStyleEditor({
  color,
  onColorChange
}) {
  const onChange = selectedColor => {
    onColorChange({
      color: selectedColor
    });
  };
  const colorPickerLabel = _i18n.i18n.translate('xpack.maps.emsVectorTileStyleEditor.colorBlendPickerLabel', {
    defaultMessage: 'Color blend'
  });
  const noColorPlaceholder = _i18n.i18n.translate('xpack.maps.emsVectorTileStyleEditor.colorBlendPickerPlaceholder', {
    defaultMessage: 'No color'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: colorPickerLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    compressed: true,
    "aria-label": colorPickerLabel,
    color: color,
    onChange: onChange,
    secondaryInputDisplay: "top",
    isClearable: true,
    format: "hex",
    placeholder: noColorPlaceholder,
    "aria-placeholder": noColorPlaceholder,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
}