"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkerList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MarkerList {
  constructor(fontSize, maxMarker) {
    (0, _defineProperty2.default)(this, "_minFontDistance", void 0);
    (0, _defineProperty2.default)(this, "_maxMarker", void 0);
    (0, _defineProperty2.default)(this, "_markers", []);
    this._minFontDistance = fontSize * 0.85;
    this._maxMarker = maxMarker;
  }
  push(marker) {
    if (marker.textY - this._maxMarker.textY < this._minFontDistance) {
      return;
    }
    if (this._markers.length === 0) {
      this._markers.push(marker);
      return;
    }

    // only push marker when there is enough vertical space to display text without collisions
    const prevMarker = this._markers[this._markers.length - 1];
    if (prevMarker.textY - marker.textY > this._minFontDistance) {
      this._markers.push(marker);
    }
  }
  getMarkers() {
    const svgs = this._markers.map(marker => {
      return marker.svg;
    });
    return [...svgs, this._maxMarker.svg];
  }
}
exports.MarkerList = MarkerList;