"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelBorderSizeProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _style_property = require("./style_property");
var _vector_style_defaults = require("../vector_style_defaults");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SMALL_SIZE = 1 / 16;
const MEDIUM_SIZE = 1 / 8;
const LARGE_SIZE = 1 / 5; // halo of 1/4 is just a square. Use smaller ratio to preserve contour on letters

function getWidthRatio(size) {
  switch (size) {
    case _constants.LABEL_BORDER_SIZES.LARGE:
      return LARGE_SIZE;
    case _constants.LABEL_BORDER_SIZES.MEDIUM:
      return MEDIUM_SIZE;
    default:
      return SMALL_SIZE;
  }
}
class LabelBorderSizeProperty extends _style_property.AbstractStyleProperty {
  constructor(options, styleName, labelSizeProperty) {
    super(options, styleName);
    (0, _defineProperty2.default)(this, "_labelSizeProperty", void 0);
    this._labelSizeProperty = labelSizeProperty;
  }
  syncLabelBorderSizeWithMb(mbLayerId, mbMap) {
    if (this.getOptions().size === _constants.LABEL_BORDER_SIZES.NONE) {
      mbMap.setPaintProperty(mbLayerId, 'text-halo-width', 0);
      return;
    }
    const widthRatio = getWidthRatio(this.getOptions().size);
    if (this._labelSizeProperty.isDynamic() && this._labelSizeProperty.isComplete()) {
      const labelSizeExpression = this._labelSizeProperty.getMbSizeExpression();
      if (labelSizeExpression) {
        mbMap.setPaintProperty(mbLayerId, 'text-halo-width', ['max', ['*', labelSizeExpression, widthRatio], 1]);
        return;
      }
    }
    const labelSize = _lodash.default.get(this._labelSizeProperty.getOptions(), 'size', _vector_style_defaults.DEFAULT_LABEL_SIZE);
    const labelBorderSize = Math.max(labelSize * widthRatio, 1);
    mbMap.setPaintProperty(mbLayerId, 'text-halo-width', labelBorderSize);
  }
}
exports.LabelBorderSizeProperty = LabelBorderSizeProperty;