"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataRequestAbortError = exports.DataRequest = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _searchErrors = require("@kbn/search-errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/util/data_request.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable max-classes-per-file */
class DataRequest {
  constructor(descriptor) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = {
      ...descriptor
    };
  }
  getData() {
    return this._descriptor.data;
  }
  isLoading() {
    return !!this._descriptor.dataRequestToken;
  }
  getMeta() {
    if (this._descriptor.dataRequestMetaAtStart) {
      return this._descriptor.dataRequestMetaAtStart;
    } else if (this._descriptor.dataRequestMeta) {
      return this._descriptor.dataRequestMeta;
    } else {
      return {};
    }
  }
  hasData() {
    return !!this._descriptor.data;
  }
  hasDataOrRequestInProgress() {
    return this.hasData() || this.isLoading();
  }
  getDataId() {
    return this._descriptor.dataId;
  }
  getRequestToken() {
    return this._descriptor.dataRequestToken;
  }
  getError() {
    return this._descriptor.error;
  }
  renderError() {
    if (!this._descriptor.error) {
      return null;
    }
    const searchErrorDisplay = (0, _searchErrors.renderSearchError)(this._descriptor.error);
    const body = searchErrorDisplay !== null && searchErrorDisplay !== void 0 && searchErrorDisplay.body ? searchErrorDisplay.body : /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, this._descriptor.error.message);
    return searchErrorDisplay !== null && searchErrorDisplay !== void 0 && searchErrorDisplay.actions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, body, searchErrorDisplay.actions) : body;
  }
}
exports.DataRequest = DataRequest;
class DataRequestAbortError extends Error {
  constructor() {
    super();
  }
}
exports.DataRequestAbortError = DataRequestAbortError;