"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocation = getLocation;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLocation(params, deps) {
  const {
    mapId,
    filters,
    query,
    refreshInterval,
    timeRange,
    initialLayers,
    hash
  } = params;
  const useHash = hash !== null && hash !== void 0 ? hash : deps.useHash;
  const appState = {};
  const queryState = {};
  if (query) appState.query = query;
  if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !(0, _esQuery.isFilterPinned)(f));
  if (timeRange) queryState.time = timeRange;
  if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => (0, _esQuery.isFilterPinned)(f));
  if (refreshInterval) queryState.refreshInterval = refreshInterval;
  let path = `/map#/${mapId || ''}`;
  path = (0, _public.setStateToKbnUrl)('_g', queryState, {
    useHash
  }, path);
  path = (0, _public.setStateToKbnUrl)('_a', appState, {
    useHash
  }, path);
  if (initialLayers && initialLayers.length) {
    const risonEncodedInitialLayers = _rison.default.encodeArray(initialLayers);
    path = `${path}&${_constants.INITIAL_LAYERS_KEY}=${encodeURIComponent(risonEncodedInitialLayers)}`;
  }
  return {
    app: _constants.APP_ID,
    path,
    state: params.dataViewSpec ? {
      dataViewSpec: params.dataViewSpec
    } : {}
  };
}