"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getByReferenceState = getByReferenceState;
exports.getByValueState = getByValueState;
exports.initializeLibraryTransforms = initializeLibraryTransforms;
var _kibana_services = require("../kibana_services");
var _content_management = require("../content_management");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getByReferenceState(state, savedObjectId) {
  var _ref;
  const {
    attributes,
    ...byRefState
  } = (_ref = state) !== null && _ref !== void 0 ? _ref : {};
  return {
    ...byRefState,
    savedObjectId
  };
}
function getByValueState(state, attributes) {
  var _ref2;
  const {
    savedObjectId,
    ...byValueState
  } = (_ref2 = state) !== null && _ref2 !== void 0 ? _ref2 : {};
  return {
    ...byValueState,
    attributes
  };
}
function initializeLibraryTransforms(isByReference, serializeByReference, serializeByValue) {
  return {
    canLinkToLibrary: async () => {
      const {
        maps_v2: maps
      } = (0, _kibana_services.getCore)().application.capabilities;
      return maps.save && !isByReference;
    },
    canUnlinkFromLibrary: async () => {
      return isByReference;
    },
    saveToLibrary: async title => {
      const state = serializeByValue();
      const {
        item: {
          id: savedObjectId
        }
      } = await (0, _content_management.getMapClient)().create({
        data: {
          ...state.rawState.attributes,
          title
        }
      });
      return savedObjectId;
    },
    getSerializedStateByReference: serializeByReference,
    getSerializedStateByValue: serializeByValue,
    checkForDuplicateTitle: async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
      await (0, _content_management.checkForDuplicateTitle)({
        title: newTitle,
        copyOnSave: false,
        lastSavedTitle: '',
        isTitleDuplicateConfirmed,
        getDisplayName: () => _constants.MAP_EMBEDDABLE_NAME,
        onTitleDuplicate
      }, {
        overlays: (0, _kibana_services.getCoreOverlays)()
      });
    }
  };
}