"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveToLibrary = saveToLibrary;
var _content_management = require("../../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function saveToLibrary(attributes, references, savedObjectId) {
  const {
    item: {
      id
    }
  } = await (savedObjectId ? (0, _content_management.getMapClient)().update({
    id: savedObjectId,
    data: attributes,
    options: {
      references
    }
  }) : (0, _content_management.getMapClient)().create({
    data: attributes,
    options: {
      references
    }
  }));
  return {
    id
  };
}