"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsCatalog = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricsCatalog {
  constructor(configCatalog, schema = 'ecs', options) {
    (0, _defineProperty2.default)(this, "catalog", void 0);
    (0, _defineProperty2.default)(this, "includeLegacyMetrics", void 0);
    (0, _defineProperty2.default)(this, "legacyMetrics", void 0);
    (0, _defineProperty2.default)(this, "_schema", void 0);
    this._schema = schema;
    const {
      includeLegacyMetrics = true,
      legacyMetrics = []
    } = options !== null && options !== void 0 ? options : {};
    this.includeLegacyMetrics = includeLegacyMetrics;
    this.legacyMetrics = new Set(legacyMetrics);
    this.catalog = this.resolveSchemaMetrics(configCatalog);
  }
  get schema() {
    return this._schema;
  }
  get(key) {
    return this.catalog[key];
  }
  getAll() {
    return this.catalog;
  }
  resolveSchemaMetrics(configCatalog) {
    if (this.schema !== 'ecs' && this.schema !== 'semconv') {
      throw new Error(`Unsupported schema: ${this.schema}`);
    }
    const catalog = Object.entries(configCatalog).reduce((acc, [key, config]) => {
      const typedKey = key;
      if (!this.includeLegacyMetrics && this.legacyMetrics.has(typedKey)) {
        return acc;
      }
      if (this.isAggregationWithSchemaVariation(config)) {
        acc[typedKey] = config[this.schema];
      } else if (this.isFormulaWithSchemaVariation(config)) {
        acc[typedKey] = {
          ...config,
          value: config.value[this.schema]
        };
      } else {
        acc[typedKey] = config;
      }
      return acc;
    }, {});
    return catalog;
  }
  isFormulaWithSchemaVariation(obj) {
    return 'value' in obj && typeof obj.value === 'object' && 'ecs' in obj.value && 'semconv' in obj.value;
  }
  isAggregationWithSchemaVariation(obj) {
    return 'ecs' in obj && 'semconv' in obj;
  }
}
exports.MetricsCatalog = MetricsCatalog;