"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToManagementMlLink = exports.useMlManagementLocatorInternal = exports.useMlManagementLocator = exports.useMlManagementLink = exports.useMlLocator = exports.useMlLink = exports.useCreateAndNavigateToMlLink = exports.useCreateAndNavigateToManagementMlLink = void 0;
var _react = require("react");
var _mlUrlState = require("@kbn/ml-url-state");
var _constants = require("@kbn/deeplinks-management/constants");
var _kibana_context = require("./kibana_context");
var _locator = require("../../../../common/constants/locator");
var _ml_management_locator = require("../../../locator/ml_management_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMlManagementLocator = () => {
  const {
    services: {
      share
    }
  } = (0, _kibana_context.useMlKibana)();
  return share.url.locators.get(_constants.MANAGEMENT_APP_LOCATOR);
};
exports.useMlManagementLocator = useMlManagementLocator;
const useMlManagementLocatorInternal = () => {
  const {
    services: {
      share
    }
  } = (0, _kibana_context.useMlKibana)();
  return new _ml_management_locator.MlManagementLocatorInternal(share);
};
exports.useMlManagementLocatorInternal = useMlManagementLocatorInternal;
const useMlLocator = () => {
  const {
    services: {
      share
    }
  } = (0, _kibana_context.useMlKibana)();
  return share.url.locators.get(_locator.ML_APP_LOCATOR);
};
exports.useMlLocator = useMlLocator;
const useMlLink = (params, getUrlParams) => {
  const [href, setHref] = (0, _react.useState)(params.page);
  const mlLocator = useMlLocator();
  (0, _react.useEffect)(function generateMlLink() {
    let isCancelled = false;
    const generateUrl = async _params => {
      if (mlLocator) {
        const url = await mlLocator.getUrl(_params, getUrlParams);
        if (!isCancelled) {
          setHref(url);
        }
      }
    };
    generateUrl(params);
    return () => {
      isCancelled = true;
    };
  }, [params, getUrlParams, mlLocator]);
  return href;
};
exports.useMlLink = useMlLink;
const useNavigateToManagementMlLink = appId => {
  const mlManagementLocatorInternal = useMlManagementLocatorInternal();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const redirectToMlPage = (0, _react.useCallback)(async (_page, pageState) => {
    if (mlManagementLocatorInternal) {
      const modifiedPageState = pageState !== null && pageState !== void 0 ? pageState : {};
      if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
        var _modifiedPageState$gl;
        // @ts-expect-error globalState override
        modifiedPageState.globalState = {
          // @ts-expect-error globalState override
          ...((_modifiedPageState$gl = modifiedPageState.globalState) !== null && _modifiedPageState$gl !== void 0 ? _modifiedPageState$gl : {}),
          refreshInterval: globalState.refreshInterval
        };
      }
      const {
        path
      } = await mlManagementLocatorInternal.getUrl(
      // @ts-expect-error globalState modification
      {
        page: _page,
        pageState: modifiedPageState
      }, appId);
      await mlManagementLocatorInternal.navigate(path, appId);
    } else {
      // eslint-disable-next-line no-console
      console.error('mlManagementLocatorInternal is not defined');
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [_ml_management_locator.MlManagementLocatorInternal, appId]);
  return redirectToMlPage;
};
exports.useNavigateToManagementMlLink = useNavigateToManagementMlLink;
const useCreateAndNavigateToMlLink = page => {
  const mlLocator = useMlLocator();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    services: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _kibana_context.useMlKibana)();
  const redirectToMlPage = (0, _react.useCallback)(async _page => {
    if (mlLocator) {
      const pageState = (globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined ? {
        globalState: {
          refreshInterval: globalState.refreshInterval
        }
      } : undefined;
      const url = await mlLocator.getUrl({
        page: _page,
        pageState
      });
      await navigateToUrl(url);
    } else {
      // eslint-disable-next-line no-console
      console.error('mlLocator is not defined');
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mlLocator, navigateToUrl]);

  // returns the onClick callback
  return (0, _react.useCallback)(() => redirectToMlPage(page), [redirectToMlPage, page]);
};
exports.useCreateAndNavigateToMlLink = useCreateAndNavigateToMlLink;
const useCreateAndNavigateToManagementMlLink = (page, appId, pageState) => {
  const mlManagementLocatorInternal = useMlManagementLocatorInternal();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const {
    services: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _kibana_context.useMlKibana)();
  const redirectToMlPage = (0, _react.useCallback)(async _page => {
    if (mlManagementLocatorInternal) {
      const modifiedPageState = pageState !== null && pageState !== void 0 ? pageState : {};
      if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
        var _modifiedPageState$gl2;
        // @ts-expect-error globalState override
        modifiedPageState.globalState = {
          // @ts-expect-error globalState override
          ...((_modifiedPageState$gl2 = modifiedPageState.globalState) !== null && _modifiedPageState$gl2 !== void 0 ? _modifiedPageState$gl2 : {}),
          refreshInterval: globalState.refreshInterval
        };
      }
      const {
        path
      } = await mlManagementLocatorInternal.getUrl(
      // @ts-expect-error globalState modification
      {
        page: _page,
        pageState: modifiedPageState
      }, appId);
      await mlManagementLocatorInternal.navigate(path, appId);
    } else {
      // eslint-disable-next-line no-console
      console.error('mlManagementLocatorInternal is not defined');
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [_ml_management_locator.MlManagementLocatorInternal, navigateToUrl, JSON.stringify(pageState)]);

  // returns the onClick callback
  return (0, _react.useCallback)(() => redirectToMlPage(page), [redirectToMlPage, page]);
};
exports.useCreateAndNavigateToManagementMlLink = useCreateAndNavigateToManagementMlLink;
const useMlManagementLink = (page, appId, pageState) => {
  const [href, setHref] = (0, _react.useState)('');
  const mlManagementLocatorInternal = useMlManagementLocatorInternal();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  (0, _react.useEffect)(function generateMlManagementLink() {
    let isCancelled = false;
    const generateUrl = async _page => {
      if (mlManagementLocatorInternal) {
        const modifiedPageState = pageState !== null && pageState !== void 0 ? pageState : {};
        if ((globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined) {
          var _modifiedPageState$gl3;
          // @ts-expect-error globalState override
          modifiedPageState.globalState = {
            // @ts-expect-error globalState override
            ...((_modifiedPageState$gl3 = modifiedPageState.globalState) !== null && _modifiedPageState$gl3 !== void 0 ? _modifiedPageState$gl3 : {}),
            refreshInterval: globalState.refreshInterval
          };
        }
        const {
          url
        } = await mlManagementLocatorInternal.getUrl(
        // @ts-expect-error globalState modification
        {
          page: _page,
          pageState: modifiedPageState
        }, appId);
        if (!isCancelled && url) {
          setHref(url);
        }
      } else {
        // eslint-disable-next-line no-console
        console.error('mlManagementLocatorInternal is not defined');
      }
    };
    generateUrl(page);
    return () => {
      isCancelled = true;
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mlManagementLocatorInternal,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify(pageState), globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval, appId, page]);
  return href;
};
exports.useMlManagementLink = useMlManagementLink;