"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasRequiredIndicesPermissions = void 0;
var _react = require("react");
var _kibana = require("../../../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHasRequiredIndicesPermissions = (indexName, isDestIndex = false) => {
  const [hasIndexPermissions, setHasIndexPermissions] = (0, _react.useState)(true);
  const {
    services: {
      mlServices: {
        mlApi: {
          hasPrivileges
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  (0, _react.useEffect)(function checkRequiredIndexPermissions() {
    async function checkPrivileges() {
      var _privileges$hasPrivil;
      const sourceIndexPriv = ['view_index_metadata'];
      const destIndexPriv = ['create_index', 'manage', 'index'];
      const privileges = await hasPrivileges({
        index: [{
          names: [indexName],
          privileges: ['read', ...(isDestIndex ? destIndexPriv : sourceIndexPriv)]
        }]
      });
      setHasIndexPermissions(((_privileges$hasPrivil = privileges.hasPrivileges) === null || _privileges$hasPrivil === void 0 ? void 0 : _privileges$hasPrivil.has_all_requested) === true);
    }
    checkPrivileges();
  }, [hasPrivileges, indexName, isDestIndex]);
  if (indexName === '') {
    return;
  }
  return hasIndexPermissions;
};
exports.useHasRequiredIndicesPermissions = useHasRequiredIndicesPermissions;