"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegressionExploration = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _exploration_page_wrapper = require("../exploration_page_wrapper");
var _evaluate_panel = require("./evaluate_panel");
var _feature_importance_summary = require("../total_feature_importance_summary/feature_importance_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/regression_exploration/regression_exploration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RegressionExploration = ({
  jobId
}) => /*#__PURE__*/_react.default.createElement(_exploration_page_wrapper.ExplorationPageWrapper, {
  jobId: jobId,
  title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.regressionExploration.tableJobIdTitle', {
    defaultMessage: 'Destination index for regression job ID {jobId}',
    values: {
      jobId
    }
  }),
  EvaluatePanel: _evaluate_panel.EvaluatePanel,
  FeatureImportanceSummaryPanel: _feature_importance_summary.FeatureImportanceSummaryPanel,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 3
  }
});
exports.RegressionExploration = RegressionExploration;