"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMessagesPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _job_messages = require("../../../../components/job_messages");
var _toast_notification_service = require("../../../../services/toast_notification_service");
var _kibana = require("../../../../contexts/kibana");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _component_utils = require("../../../../util/component_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/job_details/job_messages_pane.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobMessagesPane = exports.JobMessagesPane = /*#__PURE__*/_react.default.memo(({
  jobId,
  start,
  end,
  actionHandler,
  refreshJobList,
  showClearButton
}) => {
  const canCreateJob = (0, _check_capabilities.checkPermission)('canCreateJob');
  const [messages, setMessages] = (0, _react.useState)([]);
  const [notificationIndices, setNotificationIndices] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [errorMessage, setErrorMessage] = (0, _react.useState)('');
  const [isClearing, setIsClearing] = (0, _react.useState)(false);
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const mlApi = (0, _kibana.useMlApi)();
  const fetchMessages = async () => {
    setIsLoading(true);
    try {
      const messagesResp = await mlApi.jobs.jobAuditMessages({
        jobId,
        start,
        end
      });
      setMessages(messagesResp.messages);
      setNotificationIndices(messagesResp.notificationIndices);
      setIsLoading(false);
    } catch (error) {
      setIsLoading(false);
      toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobService.jobAuditMessagesErrorTitle', {
        defaultMessage: 'Error loading job messages'
      }));
      setErrorMessage((0, _mlErrorUtils.extractErrorMessage)(error));
    }
  };

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const refreshMessage = (0, _react.useCallback)(fetchMessages, [jobId]);

  // Clear messages for last 24hrs and refresh jobs list
  const clearMessages = (0, _react.useCallback)(async () => {
    setIsClearing(true);
    try {
      await mlApi.jobs.clearJobAuditMessages(jobId, notificationIndices);
      setIsClearing(false);
      if (typeof refreshJobList === 'function') {
        refreshJobList();
      }
    } catch (e) {
      setIsClearing(false);
      toastNotificationService.displayErrorToast(e, _i18n.i18n.translate('xpack.ml.jobMessages.clearJobAuditMessagesErrorTitle', {
        defaultMessage: 'Error clearing job message warnings and errors'
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobId, JSON.stringify(notificationIndices)]);
  (0, _react.useEffect)(() => {
    fetchMessages();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const disabled = notificationIndices.length === 0;
  const clearButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    isLoading: isClearing,
    isDisabled: disabled,
    onClick: (0, _component_utils.blurButtonOnClick)(() => {
      clearMessages();
    }),
    "data-test-subj": "mlJobMessagesClearButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobMessages.clearMessagesLabel",
    defaultMessage: "Clear notifications",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canCreateJob && showClearButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 44
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, canCreateJob && showClearButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, disabled === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.ml.jobMessages.clearJobAuditMessagesDisabledTooltip', {
      defaultMessage: 'Notification clearing not supported.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }, clearButton) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.ml.jobMessages.clearJobAuditMessagesTooltip', {
      defaultMessage: 'Clears warning icon from jobs list for messages produced in the last 24 hours.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 19
    }
  }, clearButton))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_job_messages.JobMessages, {
    refreshMessage: refreshMessage,
    messages: messages,
    loading: isLoading,
    error: errorMessage,
    actionHandler: actionHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }))));
});