"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMlSharedServices = getMlSharedServices;
var _elastic_models_service = require("./elastic_models_service");
var _http_service = require("./http_service");
var _ml_api_service = require("./ml_api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides ML services exposed from the plugin start.
 */
function getMlSharedServices(httpStart) {
  const httpService = new _http_service.HttpService(httpStart);
  const mlApi = (0, _ml_api_service.mlApiProvider)(httpService);
  return {
    elasticModels: new _elastic_models_service.ElasticModels(mlApi.trainedModels),
    mlApi
  };
}