"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jobCloningService = exports.JobCloningService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class JobCloningService {
  constructor() {
    // tempJobCloningData -> used to pass a job object between the job management page and
    // and the advanced wizard.
    // if populated when loading the advanced wizard, the job is used for cloning.
    // if populated when loading the job management page, the start datafeed modal
    // is automatically opened.
    (0, _defineProperty2.default)(this, "tempJobCloningData", {
      createdBy: undefined,
      datafeed: undefined,
      job: undefined,
      skipTimeRangeStep: false,
      start: undefined,
      end: undefined,
      calendars: undefined,
      autoSetTimeRange: false
    });
  }
  getJobCloningData() {
    return this.tempJobCloningData;
  }
  clearJobCloningData() {
    this.tempJobCloningData = {
      createdBy: undefined,
      datafeed: undefined,
      job: undefined,
      skipTimeRangeStep: false,
      start: undefined,
      end: undefined,
      calendars: undefined,
      autoSetTimeRange: false
    };
  }
  stashJobForCloning(jobCreator, skipTimeRangeStep, includeTimeRange, autoSetTimeRange = false) {
    var _jobCreator$createdBy;
    const tempJobCloningData = {
      job: jobCreator.jobConfig,
      datafeed: jobCreator.datafeedConfig,
      createdBy: (_jobCreator$createdBy = jobCreator.createdBy) !== null && _jobCreator$createdBy !== void 0 ? _jobCreator$createdBy : undefined,
      // skip over the time picker step of the wizard
      skipTimeRangeStep,
      calendars: jobCreator.calendars,
      ...(includeTimeRange === true && autoSetTimeRange === false ?
      // auto select the start and end dates of the time picker
      {
        start: jobCreator.start,
        end: jobCreator.end
      } : {
        autoSetTimeRange: true
      })
    };
    this.tempJobCloningData = tempJobCloningData;
  }
  checkForAutoStartDatafeed() {
    const job = this.tempJobCloningData.job;
    const datafeed = this.tempJobCloningData.datafeed;
    if (job !== undefined) {
      this.tempJobCloningData.job = undefined;
      this.tempJobCloningData.datafeed = undefined;
      this.tempJobCloningData.createdBy = undefined;
      const hasDatafeed = (0, _mlIsPopulatedObject.isPopulatedObject)(datafeed);
      const datafeedId = hasDatafeed ? datafeed.datafeed_id : '';
      return {
        id: job.job_id,
        hasDatafeed,
        latestTimestampSortValue: 0,
        datafeedId
      };
    }
  }
  stashJobCloningData(config) {
    this.tempJobCloningData = config;
  }
  get createdBy() {
    return this.tempJobCloningData.createdBy;
  }
  get datafeed() {
    return this.tempJobCloningData.datafeed;
  }
  get job() {
    return this.tempJobCloningData.job;
  }
  get skipTimeRangeStep() {
    return this.tempJobCloningData.skipTimeRangeStep;
  }
  get start() {
    return this.tempJobCloningData.start;
  }
  get end() {
    return this.tempJobCloningData.end;
  }
  get calendars() {
    return this.tempJobCloningData.calendars;
  }
  get autoSetTimeRange() {
    return this.tempJobCloningData.autoSetTimeRange;
  }
}
exports.JobCloningService = JobCloningService;
const jobCloningService = exports.jobCloningService = new JobCloningService();