"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarsListUI = exports.CalendarsList = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _eui = require("@elastic/eui");
var _header = require("./header");
var _table = require("./table");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _check_ml_nodes = require("../../../ml_nodes_check/check_ml_nodes");
var _delete_calendars = require("./delete_calendars");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _help_menu = require("../../../components/help_menu");
var _dst_utils = require("../dst_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/settings/calendars/list/calendars_list.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CalendarsListUI extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "loadCalendars", async () => {
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      this.setState({
        loading: true
      });
      try {
        const calendars = (await mlApi.calendars()).filter(calendar => (0, _dst_utils.isDstCalendar)(calendar) === this.props.isDst);
        this.setState({
          calendars,
          loading: false,
          isDestroyModalVisible: false
        });
      } catch (error) {
        console.log(error);
        this.setState({
          loading: false
        });
        const {
          toasts
        } = this.props.kibana.services.notifications;
        toasts.addDanger(_i18n.i18n.translate('xpack.ml.calendarsList.errorWithLoadingListOfCalendarsErrorMessage', {
          defaultMessage: 'An error occurred loading the list of calendars.'
        }));
        const toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(toasts);
        toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.calendarsList.errorWithLoadingListOfCalendarsErrorMessage', {
          defaultMessage: 'An error occurred loading the list of calendars.'
        }));
      }
    });
    (0, _defineProperty2.default)(this, "closeDestroyModal", () => {
      this.setState({
        isDestroyModalVisible: false,
        calendarId: null
      });
    });
    (0, _defineProperty2.default)(this, "showDestroyModal", () => {
      this.setState({
        isDestroyModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "setSelectedCalendarList", selectedCalendars => {
      this.setState({
        selectedForDeletion: selectedCalendars
      });
    });
    (0, _defineProperty2.default)(this, "deleteCalendars", () => {
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      const toasts = this.props.kibana.services.notifications.toasts;
      const {
        selectedForDeletion
      } = this.state;
      this.closeDestroyModal();
      (0, _delete_calendars.deleteCalendars)(mlApi, toasts, selectedForDeletion, this.loadCalendars);
    });
    (0, _defineProperty2.default)(this, "addRequiredFieldsToList", (calendarsList = []) => {
      for (let i = 0; i < calendarsList.length; i++) {
        calendarsList[i].job_ids_string = calendarsList[i].job_ids.join(', ');
        calendarsList[i].events_length = calendarsList[i].events.length;
      }
      return calendarsList;
    });
    this.state = {
      loading: true,
      calendars: [],
      isDestroyModalVisible: false,
      calendarId: null,
      selectedForDeletion: [],
      nodesAvailable: (0, _check_ml_nodes.mlNodesAvailable)()
    };
  }
  componentDidMount() {
    this.loadCalendars();
  }
  render() {
    const {
      calendars,
      selectedForDeletion,
      loading,
      nodesAvailable
    } = this.state;
    const {
      canCreateCalendar,
      canDeleteCalendar
    } = this.props;
    let destroyModal = '';
    const helpLink = this.props.kibana.services.docLinks.links.ml.calendars;
    if (this.state.isDestroyModalVisible) {
      const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
      destroyModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "data-test-subj": 'mlCalendarDeleteConfirmation',
        "aria-labelledby": confirmModalTitleId,
        title: _i18n.i18n.translate('xpack.ml.calendarsList.deleteCalendarsModal.deleteMultipleCalendarsTitle', {
          defaultMessage: 'Delete {calendarsCount, plural, one {{calendarsList}} other {# calendars}}?',
          values: {
            calendarsCount: selectedForDeletion.length,
            calendarsList: selectedForDeletion.map(c => c.calendar_id).join(', ')
          }
        }),
        titleProps: {
          id: confirmModalTitleId
        },
        onCancel: this.closeDestroyModal,
        onConfirm: this.deleteCalendars,
        cancelButtonText: _i18n.i18n.translate('xpack.ml.calendarsList.deleteCalendarsModal.cancelButtonLabel', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.ml.calendarsList.deleteCalendarsModal.deleteButtonLabel', {
          defaultMessage: 'Delete'
        }),
        buttonColor: "danger",
        defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "mlPageCalendarManagement",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_header.CalendarsListHeader, {
      totalCount: calendars.length,
      refreshCalendars: this.loadCalendars,
      isDst: this.props.isDst,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_table.CalendarsListTable, {
      loading: loading,
      calendarsList: this.addRequiredFieldsToList(calendars),
      onDeleteClick: this.showDestroyModal,
      canCreateCalendar: canCreateCalendar,
      canDeleteCalendar: canDeleteCalendar,
      mlNodesAvailable: nodesAvailable,
      setSelectedCalendarList: this.setSelectedCalendarList,
      itemsSelected: selectedForDeletion.length > 0,
      isDst: this.props.isDst,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    }), destroyModal), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
      docLink: helpLink,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }));
  }
}
exports.CalendarsListUI = CalendarsListUI;
(0, _defineProperty2.default)(CalendarsListUI, "propTypes", {
  canCreateCalendar: _propTypes.PropTypes.bool.isRequired,
  canDeleteCalendar: _propTypes.PropTypes.bool.isRequired,
  isDst: _propTypes.PropTypes.bool.isRequired
});
const CalendarsList = exports.CalendarsList = (0, _public.withKibana)(CalendarsListUI);