"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAnomalySourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _anomaly_job_selector = require("./anomaly_job_selector");
var _layer_selector = require("./layer_selector");
var _util = require("./util");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/maps/create_anomaly_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CreateAnomalySourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "onTypicalActualChange", typicalActual => {
      if (!this._isMounted) {
        return;
      }
      this.setState({
        typicalActual
      }, () => {
        this.configChange();
      });
    });
    (0, _defineProperty2.default)(this, "previewLayer", jobId => {
      if (!this._isMounted) {
        return;
      }
      this.setState({
        jobId
      }, () => {
        this.configChange();
      });
    });
  }
  configChange() {
    if (this.state.jobId) {
      this.props.onSourceConfigChange({
        jobId: this.state.jobId,
        typicalActual: this.state.typicalActual || _util.ML_ANOMALY_LAYERS.ACTUAL
      });
    }
  }
  componentDidMount() {
    this._isMounted = true;
  }
  render() {
    const selector = this.state.jobId ? /*#__PURE__*/_react.default.createElement(_layer_selector.LayerSelector, {
      onChange: this.onTypicalActualChange,
      typicalActual: this.state.typicalActual || _util.ML_ANOMALY_LAYERS.ACTUAL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_anomaly_job_selector.AnomalyJobSelector, {
      onJobChange: this.previewLayer,
      mlJobsService: this.props.mlJobsService,
      jobsManagementPath: this.props.jobsManagementPath,
      canCreateJobs: this.props.canCreateJobs,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }), selector);
  }
}
exports.CreateAnomalySourceEditor = CreateAnomalySourceEditor;