"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelDeploymentState = void 0;
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Resolves result model state based on the state of each deployment.
 *
 * If at least one deployment is in the STARTED state, the model state is STARTED.
 * Then if none of the deployments are in the STARTED state, but at least one is in the STARTING state, the model state is STARTING.
 * If all deployments are in the STOPPING state, the model state is STOPPING.
 */
const getModelDeploymentState = model => {
  var _model$stats, _model$stats$deployme, _model$stats2, _model$stats2$deploym, _model$stats3, _model$stats3$deploym, _model$stats4, _model$stats4$deploym;
  if (!((_model$stats = model.stats) !== null && _model$stats !== void 0 && (_model$stats$deployme = _model$stats.deployment_stats) !== null && _model$stats$deployme !== void 0 && _model$stats$deployme.length)) return;
  if ((_model$stats2 = model.stats) !== null && _model$stats2 !== void 0 && (_model$stats2$deploym = _model$stats2.deployment_stats) !== null && _model$stats2$deploym !== void 0 && _model$stats2$deploym.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTED)) {
    return _mlTrainedModelsUtils.MODEL_STATE.STARTED;
  }
  if ((_model$stats3 = model.stats) !== null && _model$stats3 !== void 0 && (_model$stats3$deploym = _model$stats3.deployment_stats) !== null && _model$stats3$deploym !== void 0 && _model$stats3$deploym.some(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STARTING)) {
    return _mlTrainedModelsUtils.MODEL_STATE.STARTING;
  }
  if ((_model$stats4 = model.stats) !== null && _model$stats4 !== void 0 && (_model$stats4$deploym = _model$stats4.deployment_stats) !== null && _model$stats4$deploym !== void 0 && _model$stats4$deploym.every(v => v.state === _mlTrainedModelsUtils.DEPLOYMENT_STATE.STOPPING)) {
    return _mlTrainedModelsUtils.MODEL_STATE.STOPPING;
  }
};
exports.getModelDeploymentState = getModelDeploymentState;