"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstructionSteps = getInstructionSteps;
var _kibana = require("./kibana");
var _elasticsearch = require("./elasticsearch");
var _logstash = require("./logstash");
var _beats = require("./beats");
var _apm = require("./apm");
var _constants = require("../constants");
var _constants2 = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInstructionSteps(productName, product, step, meta, opts) {
  switch (productName) {
    case _constants2.KIBANA_SYSTEM_ID:
      if (step === _constants.INSTRUCTION_STEP_ENABLE_METRICBEAT) {
        return (0, _kibana.getKibanaInstructionsForEnablingMetricbeat)(product, meta, opts);
      }
      if (step === _constants.INSTRUCTION_STEP_DISABLE_INTERNAL) {
        return (0, _kibana.getKibanaInstructionsForDisablingInternalCollection)(product, meta, opts);
      }
    case _constants2.ELASTICSEARCH_SYSTEM_ID:
      if (step === _constants.INSTRUCTION_STEP_ENABLE_METRICBEAT) {
        return (0, _elasticsearch.getElasticsearchInstructionsForEnablingMetricbeat)(product, meta, opts);
      }
      if (step === _constants.INSTRUCTION_STEP_DISABLE_INTERNAL) {
        return (0, _elasticsearch.getElasticsearchInstructionsForDisablingInternalCollection)(product, meta, opts);
      }
    case _constants2.LOGSTASH_SYSTEM_ID:
      if (step === _constants.INSTRUCTION_STEP_ENABLE_METRICBEAT) {
        return (0, _logstash.getLogstashInstructionsForEnablingMetricbeat)(product, meta, opts);
      }
      if (step === _constants.INSTRUCTION_STEP_DISABLE_INTERNAL) {
        return (0, _logstash.getLogstashInstructionsForDisablingInternalCollection)(product, meta, opts);
      }
    case _constants2.BEATS_SYSTEM_ID:
      if (step === _constants.INSTRUCTION_STEP_ENABLE_METRICBEAT) {
        return (0, _beats.getBeatsInstructionsForEnablingMetricbeat)(product, meta, opts);
      }
      if (step === _constants.INSTRUCTION_STEP_DISABLE_INTERNAL) {
        return (0, _beats.getBeatsInstructionsForDisablingInternalCollection)(product, meta, opts);
      }
    case _constants2.APM_SYSTEM_ID:
      if (step === _constants.INSTRUCTION_STEP_ENABLE_METRICBEAT) {
        return (0, _apm.getApmInstructionsForEnablingMetricbeat)(product, meta, opts);
      }
      if (step === _constants.INSTRUCTION_STEP_DISABLE_INTERNAL) {
        return (0, _apm.getApmInstructionsForDisablingInternalCollection)(product, meta, opts);
      }
  }
  return [];
}