"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMissingFieldErrors = getMissingFieldErrors;
exports.getRequiredFieldError = getRequiredFieldError;
exports.hasErrors = hasErrors;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRequiredFieldError(field) {
  return _i18n.i18n.translate('xpack.monitoring.alerts.migrate.manageAction.requiredFieldError', {
    defaultMessage: '{field} is a required field.',
    values: {
      field: (0, _lodash.upperFirst)(field)
    }
  });
}
function getMissingFieldErrors(data, defaultData) {
  const errors = {};
  for (const key in data) {
    if (!Object.hasOwn(data, key)) {
      continue;
    }
    if ((0, _lodash.isString)(defaultData[key])) {
      if (!data[key] || data[key].length === 0) {
        errors[key] = getRequiredFieldError(key);
      }
    } else if ((0, _lodash.isNumber)(defaultData[key])) {
      if (isNaN(data[key]) || data[key] === 0) {
        errors[key] = getRequiredFieldError(key);
      }
    }
  }
  return errors;
}
function hasErrors(errors) {
  for (const error in errors) {
    if (error.length) {
      return true;
    }
  }
  return false;
}