"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasMonitoringCluster = hasMonitoringCluster;
exports.instantiateClient = instantiateClient;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* Provide a dedicated Elasticsearch client for Monitoring
 * The connection options can be customized for the Monitoring application
 * This allows the app to connect to a dedicated monitoring cluster even if
 * Kibana itself is connected to a production cluster.
 */

function instantiateClient(elasticsearchConfig, log, elasticsearchStart) {
  const isMonitoringCluster = hasMonitoringCluster(elasticsearchConfig);
  const cluster = isMonitoringCluster ? elasticsearchStart.createClient('monitoring', elasticsearchConfig) : elasticsearchStart.client;
  const configSource = isMonitoringCluster ? 'monitoring' : 'production';
  log.info(`config sourced from: ${configSource} cluster`);
  return cluster;
}
function hasMonitoringCluster(config) {
  return Boolean(config.hosts && config.hosts[0]);
}