"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.categorizeEntries = categorizeEntries;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function categorizeEntries({
  entries
}) {
  return entries.reduce((acc, entry) => {
    var _entry$labels$categor, _entry$labels, _ref, _entry$labels$categor2, _entry$labels2;
    const categoryKey = (_entry$labels$categor = (_entry$labels = entry.labels) === null || _entry$labels === void 0 ? void 0 : _entry$labels.category) !== null && _entry$labels$categor !== void 0 ? _entry$labels$categor : entry.id;
    const existingEntry = acc.find(item => item.categoryKey === categoryKey);
    if (existingEntry) {
      existingEntry.entries.push(entry);
      return acc;
    }
    return acc.concat({
      categoryKey,
      title: (_ref = (_entry$labels$categor2 = (_entry$labels2 = entry.labels) === null || _entry$labels2 === void 0 ? void 0 : _entry$labels2.category) !== null && _entry$labels$categor2 !== void 0 ? _entry$labels$categor2 : entry.title) !== null && _ref !== void 0 ? _ref : 'No title',
      entries: [entry],
      '@timestamp': entry['@timestamp']
    });
  }, []);
}