"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = exports.coreStartMock = void 0;
var _react = _interopRequireDefault(require("react"));
var _history = require("history");
var _reactQuery = require("@kbn/react-query");
var _react2 = require("@testing-library/react");
var _mocks = require("@kbn/core/public/mocks");
var _i18nReact = require("@kbn/i18n-react");
var _mock = require("@kbn/observability-ai-assistant-plugin/public/mock");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _app_context = require("../context/app_context");
var _redirect_to_home_if_unauthorized = require("../routes/components/redirect_to_home_if_unauthorized");
var _config = require("../routes/config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/helpers/test_helper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const coreStartMock = exports.coreStartMock = _mocks.coreMock.createStart();
const queryClient = new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      retry: false
    }
  },
  logger: {
    // eslint-disable-next-line no-console
    log: console.log,
    // eslint-disable-next-line no-console
    warn: console.warn,
    error: () => {}
  }
});
const render = (component, mocks) => {
  var _mocks$appContextValu;
  const history = (0, _history.createMemoryHistory)();
  const startDeps = {
    observabilityAIAssistant: _mock.observabilityAIAssistantPluginMock.createStartContract()
  };
  const mergedCoreStartMock = (0, _lodash.merge)(coreStartMock, {
    application: {
      capabilities: {
        management: {
          ai: {
            observabilityAiAssistantManagement: true
          }
        },
        observabilityAIAssistant: {
          show: true
        }
      }
    }
  }, mocks === null || mocks === void 0 ? void 0 : mocks.coreStart);
  const appContextValue = (_mocks$appContextValu = mocks === null || mocks === void 0 ? void 0 : mocks.appContextValue) !== null && _mocks$appContextValu !== void 0 ? _mocks$appContextValu : {
    setBreadcrumbs: () => {},
    config: {
      logSourcesEnabled: true,
      spacesEnabled: true
    }
  };
  const TestWrapper = ({
    children
  }) =>
  /*#__PURE__*/
  // @ts-ignore
  _react.default.createElement(_i18nReact.__IntlProvider, {
    locale: "en-US",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_redirect_to_home_if_unauthorized.RedirectToHomeIfUnauthorized, {
    coreStart: mergedCoreStartMock,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...mergedCoreStartMock,
      ...startDeps
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: appContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.aIAssistantManagementObservabilityRouter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, children))))));
  const renderResult = (0, _react2.render)(component, {
    wrapper: TestWrapper
  });
  return {
    ...renderResult,
    rerender: newComponent => {
      renderResult.rerender(newComponent);
    }
  };
};
exports.render = render;