"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFunctions = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _common = require("../../common");
var _system_prompt = require("../prompts/system_prompt");
var _get_inference_id_from_write_index = require("../service/knowledge_base_service/get_inference_id_from_write_index");
var _kibana = require("./kibana");
var _context = require("./context/context");
var _summarize = require("./summarize");
var _elasticsearch = require("./elasticsearch");
var _get_dataset_info = require("./get_dataset_info");
var _execute_connector = require("./execute_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerFunctions = async ({
  client,
  functions,
  resources,
  signal,
  scopes,
  pluginsStart
}) => {
  var _await$getInferenceId;
  const registrationParameters = {
    client,
    functions,
    resources,
    signal,
    scopes
  };
  const isServerless = !!resources.plugins.serverless;
  const isObservabilityDeployment = scopes.includes('observability');
  const isGenericDeployment = scopes.length === 0 || scopes.length === 1 && scopes[0] === 'all';
  const {
    inferenceModelState
  } = await client.getKnowledgeBaseStatus();
  const isKnowledgeBaseReady = inferenceModelState === _common.InferenceModelState.READY;

  // determine if product documentation is installed
  const llmTasks = pluginsStart === null || pluginsStart === void 0 ? void 0 : pluginsStart.llmTasks;
  const esClient = (await resources.context.core).elasticsearch.client;
  const inferenceId = (_await$getInferenceId = await (0, _get_inference_id_from_write_index.getInferenceIdFromWriteIndex)(esClient, resources.logger)) !== null && _await$getInferenceId !== void 0 ? _await$getInferenceId : _inferenceCommon.defaultInferenceEndpoints.ELSER;
  const isProductDocAvailable = llmTasks ? await llmTasks.retrieveDocumentationAvailable({
    inferenceId
  }) : false;
  functions.registerInstruction(({
    availableFunctionNames
  }) => (0, _system_prompt.getSystemPrompt)({
    availableFunctionNames,
    isServerless,
    isKnowledgeBaseReady,
    isObservabilityDeployment,
    isGenericDeployment,
    isProductDocAvailable
  }));
  if (isKnowledgeBaseReady) {
    (0, _summarize.registerSummarizationFunction)(registrationParameters);
  }
  (0, _context.registerContextFunction)({
    ...registrationParameters,
    isKnowledgeBaseReady
  });
  (0, _elasticsearch.registerElasticsearchFunction)(registrationParameters);
  const request = registrationParameters.resources.request;
  if ('id' in request) {
    (0, _kibana.registerKibanaFunction)({
      ...registrationParameters,
      resources: {
        ...registrationParameters.resources,
        request
      }
    });
  }
  (0, _get_dataset_info.registerGetDatasetInfoFunction)(registrationParameters);
  (0, _execute_connector.registerExecuteConnectorFunction)(registrationParameters);
};
exports.registerFunctions = registerFunctions;