"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagedOtlpServiceAvailability = useManagedOtlpServiceAvailability;
var _public = require("@kbn/kibana-react-plugin/public");
var _feature_flags = require("../../../common/feature_flags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useManagedOtlpServiceAvailability() {
  const {
    services: {
      featureFlags,
      observability,
      context: {
        isServerless
      }
    }
  } = (0, _public.useKibana)();

  /**
   * mOTLP service is always available for Serverless projects
   */
  if (isServerless) {
    return true;
  }
  const isFeatureEnabled = featureFlags.getBooleanValue(_feature_flags.IS_MANAGED_OTLP_SERVICE_ENABLED, false);
  const managedOtlpServiceUrl = observability.config.managedOtlpServiceUrl;
  return isFeatureEnabled && Boolean(managedOtlpServiceUrl);
}