"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepProgressPayloadRT = exports.LogsDetectLoadingStepPayloadRT = exports.IntegrationRT = exports.InstallIntegrationsStepPayloadRT = exports.ElasticAgentStepPayloadRT = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationRT = exports.IntegrationRT = t.intersection([t.type({
  installSource: t.union([t.literal('registry'), t.literal('custom')]),
  pkgName: t.string,
  pkgVersion: t.string,
  title: t.string,
  config: t.string,
  dataStreams: t.array(t.type({
    type: t.string,
    dataset: t.string
  })),
  kibanaAssets: t.array(t.type({
    type: t.string,
    id: t.string
  }))
}), t.partial({
  metadata: t.type({
    hostname: t.string
  })
})]);
const LogsDetectLoadingStepPayloadRT = exports.LogsDetectLoadingStepPayloadRT = t.type({
  os: t.string,
  arch: t.string
});
const ElasticAgentStepPayloadRT = exports.ElasticAgentStepPayloadRT = t.type({
  agentId: t.string
});
const InstallIntegrationsStepPayloadRT = exports.InstallIntegrationsStepPayloadRT = t.array(IntegrationRT);
const StepProgressPayloadRT = exports.StepProgressPayloadRT = t.union([LogsDetectLoadingStepPayloadRT, ElasticAgentStepPayloadRT, InstallIntegrationsStepPayloadRT]);