"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditAnnotationHelper = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEditAnnotationHelper = ({
  reset,
  editAnnotation,
  setIsCreateOpen
}) => {
  (0, _react.useEffect)(() => {
    var _editAnnotation$event, _editAnnotation$event2;
    if (!editAnnotation) return;
    const eventEnd = (_editAnnotation$event = editAnnotation.event) === null || _editAnnotation$event === void 0 ? void 0 : _editAnnotation$event.end;
    reset({
      ...editAnnotation,
      '@timestamp': (0, _moment.default)(editAnnotation['@timestamp']),
      event: {
        start: (0, _moment.default)((_editAnnotation$event2 = editAnnotation.event) === null || _editAnnotation$event2 === void 0 ? void 0 : _editAnnotation$event2.start),
        end: eventEnd ? (0, _moment.default)(eventEnd) : undefined
      }
    });
    setIsCreateOpen(true);
  }, [editAnnotation, setIsCreateOpen, reset]);
};
exports.useEditAnnotationHelper = useEditAnnotationHelper;