"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertDetailsPageViewEbt = void 0;
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Telemetry hook for alert details page view in Observability.
 */

const useAlertDetailsPageViewEbt = ({
  ruleType
}) => {
  const {
    telemetryClient
  } = (0, _kibana_react.useKibana)().services;
  (0, _react.useEffect)(() => {
    if (ruleType) {
      telemetryClient.reportAlertDetailsPageView(ruleType);
    }
  }, [ruleType, telemetryClient]);
};
exports.useAlertDetailsPageViewEbt = useAlertDetailsPageViewEbt;