"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchBulkCases = void 0;
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchBulkCases = ({
  ids = []
}) => {
  const [cases, setCases] = (0, _react.useState)([]);
  const [error, setError] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    cases: casesService
  } = (0, _kibana_react.useKibana)().services;
  (0, _react.useEffect)(() => {
    if (ids.length && casesService) {
      const getBulkCasesByIds = async () => {
        return casesService.api.cases.bulkGet({
          ids
        });
      };
      setIsLoading(true);
      getBulkCasesByIds().then(res => setCases(res.cases)).catch(resError => setError(resError)).finally(() => setIsLoading(false));
    }
  }, [casesService, casesService === null || casesService === void 0 ? void 0 : casesService.api.cases, ids]);
  return {
    cases,
    isLoading,
    error
  };
};
exports.useFetchBulkCases = useFetchBulkCases;