"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSummaryTimeRange = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("..");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSummaryTimeRange = unifiedSearchDateRange => {
  var _bucketSize$intervalS, _ref, _bucketSize$dateForma;
  const timeBuckets = (0, _.useTimeBuckets)();
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  const bucketSize = (0, _react.useMemo)(() => (0, _.calculateTimeRangeBucketSize)(unifiedSearchDateRange, timeBuckets), [unifiedSearchDateRange, timeBuckets]);
  return (0, _.getAlertSummaryTimeRange)(unifiedSearchDateRange, (_bucketSize$intervalS = bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) !== null && _bucketSize$intervalS !== void 0 ? _bucketSize$intervalS : _constants.DEFAULT_INTERVAL, (_ref = (_bucketSize$dateForma = bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) !== null && _bucketSize$dateForma !== void 0 ? _bucketSize$dateForma : dateFormat) !== null && _ref !== void 0 ? _ref : _constants.DEFAULT_DATE_FORMAT);
};
exports.useSummaryTimeRange = useSummaryTimeRange;