"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseLinks = useCaseLinks;
var _react = require("react");
var _kibana_react = require("../../../utils/kibana_react");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given a list of cases, returns the link to the first case's detail page,
 * and the link to the overview page if there is > 1 case.
 * @param cases the cases to get links for
 * @returns the first case link and the cases overview link
 */
function useCaseLinks(cases) {
  const [activeSpace, setActiveSpace] = (0, _react.useState)(null);
  const [firstCaseLink, setFirstCaseLink] = (0, _react.useState)(null);
  const [casesOverviewLink, setCasesOverviewLink] = (0, _react.useState)(null);
  const {
    share,
    http: {
      basePath: httpBasePath
    },
    spaces
  } = (0, _kibana_react.useKibana)().services;
  const basePath = httpBasePath.serverBasePath;
  (0, _react.useEffect)(() => {
    if (!spaces) return;
    const sub = spaces.getActiveSpace$().subscribe(space => {
      setActiveSpace(space.id);
    });
    return () => {
      sub.unsubscribe();
    };
  }, [spaces]);
  const {
    casesOverviewLocator,
    caseDetailLocator
  } = (0, _react.useMemo)(() => ({
    casesOverviewLocator: share.url.locators.get(_common.casesOverviewLocatorID),
    caseDetailLocator: share.url.locators.get(_common.casesDetailLocatorID)
  }), [share.url.locators]);
  (0, _react.useEffect)(() => {
    const spaceId = activeSpace !== 'default' && activeSpace !== null ? activeSpace : undefined;
    casesOverviewLocator === null || casesOverviewLocator === void 0 ? void 0 : casesOverviewLocator.getLocation({
      basePath,
      spaceId
    }).then(location => {
      setCasesOverviewLink(location.path);
    });
    if (cases && cases.length > 0) {
      caseDetailLocator === null || caseDetailLocator === void 0 ? void 0 : caseDetailLocator.getLocation({
        caseId: cases[0].id,
        basePath,
        spaceId
      }).then(location => {
        setFirstCaseLink(location.path);
      });
    }
  }, [activeSpace, basePath, caseDetailLocator, cases, casesOverviewLocator]);
  return {
    firstCaseLink,
    casesOverviewLink
  };
}