"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_fetch_rule = require("../../../hooks/use_fetch_rule");
var _kibana_react = require("../../../utils/kibana_react");
var _use_enable_rule = require("../../../hooks/use_enable_rule");
var _use_disable_rule = require("../../../hooks/use_disable_rule");
var _use_run_rule = require("../../../hooks/use_run_rule");
var _use_update_api_key = require("../../../hooks/use_update_api_key");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rule_details/components/header_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function HeaderActions({
  ruleId,
  isLoading,
  isRuleEditable,
  onDeleteRule,
  onEditRule
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    triggersActionsUi: {
      getRuleSnoozeModal: RuleSnoozeModal,
      getUntrackModal: UntrackAlertsModal,
      getRuleHelpers
    }
  } = services;
  const [isRuleEditPopoverOpen, setIsRuleEditPopoverOpen] = (0, _react.useState)(false);
  const [snoozeModalOpen, setSnoozeModalOpen] = (0, _react.useState)(false);
  const [isUntrackAlertsModalOpen, setIsUntrackAlertsModalOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const collapsedItemActionsCss = (0, _react2.css)`
    .collapsedItemActions__deleteButton {
      color: ${euiTheme.colors.textDanger};
    }
  `;
  const {
    mutate: enableRule
  } = (0, _use_enable_rule.useEnableRule)();
  const {
    mutate: disableRule
  } = (0, _use_disable_rule.useDisableRule)();
  const {
    mutate: runRule
  } = (0, _use_run_rule.useRunRule)();
  const {
    mutate: updateAPIKey
  } = (0, _use_update_api_key.useUpdateAPIKey)();
  const onDisableModalClose = () => {
    setIsUntrackAlertsModalOpen(false);
  };
  const onDisableModalOpen = () => {
    setIsUntrackAlertsModalOpen(true);
  };
  const togglePopover = () => setIsRuleEditPopoverOpen(!isRuleEditPopoverOpen);
  const handleEditRule = () => {
    setIsRuleEditPopoverOpen(false);
    onEditRule();
  };
  const handleRemoveRule = () => {
    setIsRuleEditPopoverOpen(false);
    onDeleteRule();
  };
  const handleRunRule = () => {
    setIsRuleEditPopoverOpen(false);
    runRule({
      id: ruleId
    });
  };
  const handleUpdateAPIKey = () => {
    setIsRuleEditPopoverOpen(false);
    updateAPIKey({
      id: ruleId
    });
  };
  const handleEnableRule = () => {
    setIsRuleEditPopoverOpen(false);
    enableRule({
      id: ruleId
    });
  };
  const handleDisableRule = untrack => {
    setIsRuleEditPopoverOpen(false);
    onDisableModalClose();
    disableRule({
      id: ruleId,
      untrack
    });
  };
  const {
    rule,
    refetch
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId
  });
  if (!isRuleEditable || !rule) {
    return null;
  }
  const disableRuleOption = {
    'data-test-subj': 'disableRuleButton',
    onClick: onDisableModalOpen,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.disableRule', {
      defaultMessage: 'Disable'
    })
  };
  const enableRuleOption = {
    'data-test-subj': 'enableRuleButton',
    onClick: handleEnableRule,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.enableRule', {
      defaultMessage: 'Enable'
    })
  };
  const panels = [{
    id: 0,
    hasFocus: false,
    items: [...[rule.enabled ? disableRuleOption : enableRuleOption], {
      'data-test-subj': 'runRuleButton',
      onClick: handleRunRule,
      name: _i18n.i18n.translate('xpack.observability.ruleDetails.runRule', {
        defaultMessage: 'Run'
      })
    }, {
      'data-test-subj': 'updateAPIKeyButton',
      onClick: handleUpdateAPIKey,
      name: _i18n.i18n.translate('xpack.observability.ruleDetails.updateAPIkey', {
        defaultMessage: 'Update API key'
      })
    }, {
      isSeparator: true
    }, {
      icon: 'pencil',
      'data-test-subj': 'editRuleButton',
      onClick: handleEditRule,
      name: _i18n.i18n.translate('xpack.observability.ruleDetails.editRule', {
        defaultMessage: 'Edit'
      })
    }, {
      icon: 'trash',
      'data-test-subj': 'deleteRuleButton',
      className: 'collapsedItemActions__deleteButton',
      onClick: handleRemoveRule,
      name: _i18n.i18n.translate('xpack.observability.ruleDetails.deleteRule', {
        defaultMessage: 'Delete'
      })
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "rowReverse",
    alignItems: "center",
    "data-test-subj": `ruleType_${rule.ruleTypeId}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextRuleEditMenu",
    panelPaddingSize: "none",
    isOpen: isRuleEditPopoverOpen,
    closePopover: togglePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "actions",
      disabled: isLoading,
      fill: true,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: togglePopover,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.observability.ruleDetails.actionsButtonLabel', {
      defaultMessage: 'Actions'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    className: "actDetailsCollapsedItemActions",
    "data-test-subj": "detailsCollapsedActionPanel",
    "data-testid": "detailsCollapsedActionPanel",
    css: collapsedItemActionsCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "snoozeButton",
    "data-test-subj": "snoozeRuleButton",
    iconType: getRuleHelpers(rule).isRuleSnoozed ? 'bellSlash' : 'bell',
    onClick: () => {
      setSnoozeModalOpen(true);
    },
    "aria-label": _i18n.i18n.translate('xpack.observability.ruleDetails.snoozeButtonAriaLabel', {
      defaultMessage: 'Manage rule snooze'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }))), snoozeModalOpen && /*#__PURE__*/_react.default.createElement(RuleSnoozeModal, {
    rule: rule,
    onClose: () => {
      setSnoozeModalOpen(false);
      setIsRuleEditPopoverOpen(false);
    },
    onRuleChanged: refetch,
    onLoading: _lodash.noop,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }), isUntrackAlertsModalOpen && /*#__PURE__*/_react.default.createElement(UntrackAlertsModal, {
    onCancel: onDisableModalClose,
    onConfirm: handleDisableRule,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 9
    }
  }));
}