"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePage = RulePage;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _responseOpsRuleForm = require("@kbn/response-ops-rule-form");
var _reactRouterDom = require("react-router-dom");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/observability-shared-plugin/public");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _kibana_react = require("../../utils/kibana_react");
var _paths = require("../../../common/locators/paths");
var _constants = require("../../../common/constants");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _enhanced_rules_callout = require("./enhanced_rules_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rules/rule.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RulePage() {
  const {
    http,
    docLinks,
    observabilityAIAssistant,
    application,
    notifications,
    charts,
    serverless,
    settings,
    data,
    dataViews,
    unifiedSearch,
    actionTypeRegistry,
    ruleTypeRegistry,
    chrome,
    contentManagement,
    ...startServices
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    returnApp,
    returnPath
  } = location.state || {};
  const {
    id,
    ruleTypeId
  } = (0, _reactRouterDom.useParams)();
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    href: http.basePath.prepend(_paths.paths.observability.alerts),
    deepLinkId: 'observability-overview:alerts'
  }, {
    href: http.basePath.prepend(_paths.paths.observability.rules),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.rulesLinkText', {
      defaultMessage: 'Rules'
    })
  }, ...(ruleTypeId ? [{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.createLinkText', {
      defaultMessage: 'Create'
    })
  }] : []), ...(id ? [{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.editLinkText', {
      defaultMessage: 'Edit'
    })
  }] : [])], {
    serverless
  });
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "rulePage",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_enhanced_rules_callout.EnhancedRulesCallout, {
    ruleTypeId: ruleTypeId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_responseOpsRuleForm.RuleForm, {
    key: ruleTypeId,
    plugins: {
      http,
      application,
      notifications,
      charts,
      settings,
      data,
      dataViews,
      unifiedSearch,
      docLinks,
      ruleTypeRegistry,
      actionTypeRegistry,
      contentManagement,
      ...startServices
    },
    id: id,
    ruleTypeId: ruleTypeId,
    validConsumers: _constants.observabilityRuleCreationValidConsumers,
    multiConsumerSelection: _ruleDataUtils.AlertConsumers.ALERTS,
    onCancel: () => {
      if (returnApp && returnPath) {
        application.navigateToApp(returnApp, {
          path: returnPath
        });
      } else {
        return application.navigateToUrl(http.basePath.prepend(_paths.paths.observability.rules));
      }
    },
    onSubmit: ruleId => {
      return application.navigateToUrl(http.basePath.prepend(_paths.paths.observability.ruleDetails(ruleId)));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
}