"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelatedDashboardsResponseSchema = exports.getRelatedDashboardsParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _v = require("../../schema/related_dashboard/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRelatedDashboardsParamsSchema = exports.getRelatedDashboardsParamsSchema = _zod.z.object({
  query: _zod.z.object({
    alertId: _zod.z.string()
  })
});
const getRelatedDashboardsResponseSchema = exports.getRelatedDashboardsResponseSchema = _zod.z.object({
  suggestedDashboards: _zod.z.array(_v.suggestedDashboardSchema),
  linkedDashboards: _zod.z.array(_v.linkedDashboardSchema)
});