"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestedDashboardSchema = exports.linkedDashboardSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonDashboardSchema = {
  id: _zod.z.string(),
  title: _zod.z.string(),
  description: _zod.z.string(),
  tags: _zod.z.array(_zod.z.string()).optional()
};
const linkedDashboardSchema = exports.linkedDashboardSchema = _zod.z.object({
  ...commonDashboardSchema,
  matchedBy: _zod.z.object({
    fields: _zod.z.array(_zod.z.string()).optional(),
    index: _zod.z.array(_zod.z.string()).optional(),
    linked: _zod.z.boolean().optional()
  })
});
const suggestedDashboardSchema = exports.suggestedDashboardSchema = _zod.z.object({
  ...commonDashboardSchema,
  matchedBy: _zod.z.object({
    fields: _zod.z.array(_zod.z.string()).optional(),
    index: _zod.z.array(_zod.z.string()).optional()
  }),
  score: _zod.z.number()
});