"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsFlyoutLocatorDefinition = exports.ASSET_DETAILS_FLYOUT_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_DETAILS_FLYOUT_LOCATOR_ID = exports.ASSET_DETAILS_FLYOUT_LOCATOR_ID = 'ASSET_DETAILS_FLYOUT_LOCATOR';
class AssetDetailsFlyoutLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", ASSET_DETAILS_FLYOUT_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const tableProperties = _rison.default.encodeUnknown(params.tableProperties);
      const assetDetails = _rison.default.encodeUnknown(params.assetDetails);
      return {
        app: 'metrics',
        path: `/hosts?tableProperties=${tableProperties}&assetDetails=${assetDetails}`,
        state: {}
      };
    });
  }
}
exports.AssetDetailsFlyoutLocatorDefinition = AssetDetailsFlyoutLocatorDefinition;