"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatConversationsView = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = _interopRequireWildcard(require("react"));
var _conversation = require("./conversation");
var _conversation_header = require("./conversation_header");
var _conversation_sidebar = require("./conversation_sidebar/conversation_sidebar");
var _use_conversation_list = require("../../hooks/use_conversation_list");
var _send_message_context = require("../../context/send_message/send_message_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversations_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OnechatConversationsView = () => {
  const [isSidebarOpen, setIsSidebarOpen] = (0, _react2.useState)(true);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const mainStyles = (0, _react.css)`
    border: none;
  `;
  const backgroundStyles = (0, _react.css)`
    background-color: ${euiTheme.colors.backgroundBasePlain};
  `;
  const sidebarStyles = (0, _react.css)`
    ${backgroundStyles}
    max-block-size: calc(var(--kbn-application--content-height));
    padding: 0;
  `;
  const headerHeight = `calc(${euiTheme.size.xl} * 2)`;
  const headerStyles = (0, _react.css)`
    ${backgroundStyles}
    display: flex;
    flex-direction: column;
    justify-content: center;
    border: none;
    block-size: ${headerHeight};
  `;
  const contentStyles = (0, _react.css)`
    ${backgroundStyles}
    width: 100%;
    height: 100%;
    max-block-size: calc(var(--kbn-application--content-height) - ${headerHeight});
  `;
  const labels = {
    header: _i18n.i18n.translate('xpack.onechat.conversationsView.header', {
      defaultMessage: 'Conversation header'
    }),
    content: _i18n.i18n.translate('xpack.onechat.conversationsView.content', {
      defaultMessage: 'Conversation content'
    })
  };
  const {
    conversations = [],
    isLoading
  } = (0, _use_conversation_list.useConversationList)();
  return /*#__PURE__*/_react2.default.createElement(_send_message_context.SendMessageProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "onechatPageConversations",
    grow: false,
    panelled: false,
    mainProps: {
      css: mainStyles
    },
    responsive: [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, isSidebarOpen && /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Sidebar, {
    "data-test-subj": "onechatSidebar",
    css: sidebarStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_sidebar.ConversationSidebar, {
    conversations: conversations,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    css: headerStyles,
    bottomBorder: false,
    "aria-label": labels.header,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_header.ConversationHeader, {
    isSidebarOpen: isSidebarOpen,
    onToggleSidebar: () => {
      setIsSidebarOpen(open => !open);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "none",
    grow: true,
    contentProps: {
      css: contentStyles
    },
    "aria-label": labels.content,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation.Conversation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }))));
};
exports.OnechatConversationsView = OnechatConversationsView;