"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zodResolver = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _zod = require("@kbn/zod");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const zodResolver = schema => async (data, context, options) => {
  try {
    const values = await schema.parseAsync(data);
    return {
      values,
      errors: {}
    };
  } catch (error) {
    if (!(error instanceof _zod.z.ZodError)) {
      throw error;
    }
    const errors = error.issues.reduce((errorMap, issue) => {
      const path = issue.path.join('.');
      if (!(0, _lodash.get)(errorMap, path)) {
        (0, _saferLodashSet.set)(errorMap, path, {
          type: issue.code,
          message: issue.message
        });
      }
      return errorMap;
    }, {});
    return {
      values: {},
      errors
    };
  }
};
exports.zodResolver = zodResolver;