"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class NavigationService {
  constructor(locators) {
    (0, _defineProperty2.default)(this, "locators", void 0);
    this.locators = locators;
  }
  hasLicenseManagentLocator() {
    return Boolean(this.locators.licenseManagement);
  }
  navigateToLicenseManagementDashboard() {
    var _this$locators$licens;
    (_this$locators$licens = this.locators.licenseManagement) === null || _this$locators$licens === void 0 ? void 0 : _this$locators$licens.navigateSync({
      page: 'dashboard'
    });
  }
  navigateToLlmConnectorsManagement() {
    this.locators.management.navigateSync({
      sectionId: 'insightsAndAlerting',
      appId: 'triggersActionsConnectors/connectors'
    });
  }
}
exports.NavigationService = NavigationService;