"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatusBar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _agent_status = require("./services/agent_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/osquery/public/action_results/action_agents_status_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiColorPaletteDisplayCss = {
  border: 'none',
  borderRadius: 0,
  '&:after': {
    border: 'none'
  }
};
const AgentStatusBar = ({
  agentStatus
}) => {
  const palette = (0, _react.useMemo)(() => {
    let stop = 0;
    return _agent_status.AGENT_STATUSES.reduce((acc, status) => {
      stop += agentStatus[status] || 0;
      acc.push({
        stop,
        color: (0, _agent_status.getColorForAgentStatus)(status)
      });
      return acc;
    }, []);
  }, [agentStatus]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    css: euiColorPaletteDisplayCss,
    size: "s",
    palette: palette,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 10
    }
  });
};
exports.AgentStatusBar = AgentStatusBar;