"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdatePack = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _common = require("../../common");
var _page_paths = require("../common/page_paths");
var _constants2 = require("./constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdatePack = ({
  withRedirect,
  options
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    application: {
      navigateToApp
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useMutation)(({
    id,
    ...payload
  }) => http.put(`/api/osquery/packs/${id}`, {
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(payload)
  }), {
    onError: error => {
      var _error$body, _error$body2;
      setErrorToast(error, {
        title: error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error,
        toastMessage: error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message
      });
    },
    onSuccess: response => {
      var _response$data$name, _response$data;
      queryClient.invalidateQueries([_constants2.PACKS_ID]);
      if (withRedirect) {
        navigateToApp(_common.PLUGIN_ID, {
          path: _page_paths.pagePathGetters.packs()
        });
      }
      toasts.addSuccess(_i18n.i18n.translate('xpack.osquery.updatePack.successToastMessageText', {
        defaultMessage: 'Successfully updated "{packName}" pack',
        values: {
          packName: (_response$data$name = response === null || response === void 0 ? void 0 : (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.name) !== null && _response$data$name !== void 0 ? _response$data$name : ''
        }
      }));
    },
    ...options
  });
};
exports.useUpdatePack = useUpdatePack;