"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildActionDetailsQuery = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _lodash = require("lodash");
var _build_query = require("../../../../../utils/build_query");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildActionDetailsQuery = ({
  actionId,
  kuery,
  componentTemplateExists,
  spaceId
}) => {
  const actionIdQuery = `action_id: ${actionId}`;
  let filter = actionIdQuery;
  if (!(0, _lodash.isEmpty)(kuery)) {
    filter = filter + ` AND ${kuery}`;
  }
  const {
    bool: {
      filter: baseFilter
    }
  } = (0, _build_query.getQueryFilter)({
    filter
  });
  let extendedFilter = baseFilter;
  if (spaceId === 'default') {
    // For default space, include docs where space_id matches 'default' OR where space_id field does not exist
    extendedFilter = [{
      bool: {
        should: [{
          term: {
            space_id: 'default'
          }
        }, {
          bool: {
            must_not: {
              exists: {
                field: 'space_id'
              }
            }
          }
        }]
      }
    }, ...baseFilter];
  } else {
    // For other spaces, only include docs where space_id matches the current spaceId
    extendedFilter = [...baseFilter, {
      term: {
        space_id: spaceId
      }
    }];
  }
  const dslQuery = {
    allow_no_indices: true,
    index: componentTemplateExists ? `${_constants.ACTIONS_INDEX}*` : _common.AGENT_ACTIONS_INDEX,
    ignore_unavailable: true,
    query: {
      bool: {
        filter: extendedFilter
      }
    },
    size: 1,
    fields: ['*']
  };
  return dslQuery;
};
exports.buildActionDetailsQuery = buildActionDetailsQuery;