"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KbnPalette = exports.EUI_THEME_BOREALIS = exports.EUI_THEME_AMSTERDAM = exports.DEFAULT_FALLBACK_PALETTE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_FALLBACK_PALETTE = exports.DEFAULT_FALLBACK_PALETTE = 'default';
const EUI_THEME_AMSTERDAM = exports.EUI_THEME_AMSTERDAM = 'EUI_THEME_AMSTERDAM';
const EUI_THEME_BOREALIS = exports.EUI_THEME_BOREALIS = 'EUI_THEME_BOREALIS';
const semantic = {
  /**
   * Log level palette
   */
  LogLevel: 'log_level'
};
const categorical = {
  /**
   * Default kibana theme
   */
  Default: DEFAULT_FALLBACK_PALETTE,
  /**
   * Neutral palette
   */
  Neutral: 'neutral',
  // ---- Legacy Palettes ----
  /**
   * Kibana legacy theme v7 to v9
   */
  Kibana7: 'eui_amsterdam',
  /**
   * Kibana behind text legacy theme v7 to v9
   */
  Kibana7BehindText: 'behind_text',
  /**
   * Kibana legacy theme v4 to v7
   */
  Kibana4: 'kibana_v7_legacy',
  /**
   * Elastic classic color palette
   */
  ElasticClassic: 'elastic_brand_2023'
};
const gradient = {
  Cool: 'cool',
  Gray: 'gray',
  Red: 'red',
  Green: 'green',
  Warm: 'warm',
  Temperature: 'temperature',
  Complementary: 'complementary',
  Status: 'status',
  CompareTo: 'compare_to'
};

/**
 * Enum of all kbn palette ids, including by type
 */
const KbnPalette = exports.KbnPalette = {
  // Categorical palettes
  ...categorical,
  // Gradient palettes
  ...gradient,
  // Semantic palettes
  ...semantic,
  // ---- Deprecated palettes ----
  /**
   * Amsterdam theme
   * @deprecated use `KbnPalette.kibana7`
   */
  Amsterdam: 'eui_amsterdam_color_blind'
};