"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePanelErrorCss = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const usePanelErrorCss = () => {
  const euiTheme = (0, _eui.useEuiTheme)();
  return (0, _react.css)({
    padding: euiTheme.euiTheme.size.l,
    '& > *': {
      maxHeight: '100%',
      overflow: 'auto'
    }
  });
};
exports.usePanelErrorCss = usePanelErrorCss;