"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.productDocInstallStatusSavedObjectType = void 0;
var _consts = require("../../common/consts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Interface describing the raw attributes of the product doc install SO type.
 * Contains more fields than the mappings, which only list
 * indexed fields.
 */

const modelVersion1 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      inference_id: {
        type: 'keyword'
      }
    }
  }]
};
const productDocInstallStatusSavedObjectType = exports.productDocInstallStatusSavedObjectType = {
  name: _consts.productDocInstallStatusSavedObjectTypeName,
  hidden: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      product_name: {
        type: 'keyword'
      },
      product_version: {
        type: 'keyword'
      },
      installation_status: {
        type: 'keyword'
      },
      last_installation_date: {
        type: 'date'
      },
      index_name: {
        type: 'keyword'
      },
      inference_id: {
        type: 'keyword'
      }
    }
  },
  management: {
    importableAndExportable: false
  },
  modelVersions: {
    '1': modelVersion1
  }
};