"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseArtifactName = exports.getArtifactName = exports.DEFAULT_ELSER = void 0;
var _is_default_inference_endpoint = require("./is_default_inference_endpoint");
var _product = require("./product");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allowedProductNames = Object.values(_product.DocumentationProduct);
const DEFAULT_ELSER = exports.DEFAULT_ELSER = '.elser-2-elasticsearch';
const getArtifactName = ({
  productName,
  productVersion,
  excludeExtension = false,
  inferenceId
}) => {
  const ext = excludeExtension ? '' : '.zip';
  return `kb-product-doc-${productName}-${productVersion}${inferenceId && !(0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? `--${inferenceId}` : ''}${ext}`.toLowerCase();
};
exports.getArtifactName = getArtifactName;
const parseArtifactName = artifactName => {
  // drop ".zip" (if any)
  let name = artifactName.endsWith('.zip') ? artifactName.slice(0, -4) : artifactName;

  // pull off the final  "--<inferenceId>" (if present)
  let inferenceId;
  const lastDashDash = name.lastIndexOf('--');
  if (lastDashDash !== -1) {
    inferenceId = name.slice(lastDashDash + 2);
    name = name.slice(0, lastDashDash); // strip it for the base match
  }

  // match the main pattern kb-product-doc-<product>-<version>
  const match = name.match(/^kb-product-doc-([a-z]+)-([0-9]+\.[0-9]+)$/);
  if (!match) return;
  const productName = match[1].toLowerCase();
  const productVersion = match[2].toLowerCase();
  if (!allowedProductNames.includes(productName)) return;
  return {
    productName,
    productVersion,
    ...(inferenceId ? {
      inferenceId
    } : {})
  };
};
exports.parseArtifactName = parseArtifactName;