"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isImpliedDefaultElserInferenceId = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if inferenceId is not provided, or when provided, it is a default ELSER inference ID
 * @param inferenceId
 * @returns
 */
const isImpliedDefaultElserInferenceId = inferenceId => {
  return inferenceId === null || inferenceId === undefined || inferenceId === _inferenceCommon.defaultInferenceEndpoints.ELSER || inferenceId === _inferenceCommon.defaultInferenceEndpoints.ELSER_IN_EIS_INFERENCE_ID || typeof inferenceId === 'string' && inferenceId.toLowerCase().includes('elser');
};
exports.isImpliedDefaultElserInferenceId = isImpliedDefaultElserInferenceId;