"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableResourceManagement = enableResourceManagement;
exports.setMaximumBuckets = setMaximumBuckets;
var _common = require("@kbn/profiling-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function setMaximumBuckets({
  client
}) {
  await client.getEsClient().cluster.putSettings({
    persistent: {
      search: {
        max_buckets: _common.MAX_BUCKETS
      }
    }
  });
}
async function enableResourceManagement({
  client
}) {
  await client.getEsClient().cluster.putSettings({
    persistent: {
      xpack: {
        profiling: {
          templates: {
            enabled: true
          }
        }
      }
    }
  });
}