"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExportType = void 0;
var _loggingMocks = require("@kbn/logging-mocks");
var _reportingCommon = require("@kbn/reporting-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExportType = (overwrites = {}) => {
  return {
    id: 'test',
    name: 'Test Export Type',
    jobType: 'testJobType',
    jobContentExtension: 'pdf',
    validLicenses: [_reportingCommon.LICENSE_TYPE_GOLD],
    setup: jest.fn(),
    start: jest.fn(),
    shouldNotifyUsage: () => false,
    getFeatureUsageName: () => 'Reporting: test export',
    notifyUsage: jest.fn(),
    createJob: jest.fn(),
    runTask: jest.fn(),
    setupDeps: {},
    startDeps: {},
    http: {},
    config: {},
    logger: _loggingMocks.loggerMock.create(),
    context: {},
    ...overwrites
  };
};
exports.getExportType = getExportType;