"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logThresholdParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const persistedLogViewReferenceSchema = _configSchema.schema.object({
  logViewId: _configSchema.schema.string(),
  type: _configSchema.schema.literal('log-view-reference')
}, {
  unknowns: 'ignore'
});

// Comparators //
var Comparator = /*#__PURE__*/function (Comparator) {
  Comparator["GT"] = "more than";
  Comparator["GT_OR_EQ"] = "more than or equals";
  Comparator["LT"] = "less than";
  Comparator["LT_OR_EQ"] = "less than or equals";
  Comparator["EQ"] = "equals";
  Comparator["NOT_EQ"] = "does not equal";
  Comparator["MATCH"] = "matches";
  Comparator["NOT_MATCH"] = "does not match";
  Comparator["MATCH_PHRASE"] = "matches phrase";
  Comparator["NOT_MATCH_PHRASE"] = "does not match phrase";
  return Comparator;
}(Comparator || {});
const ComparatorSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(Comparator.GT), _configSchema.schema.literal(Comparator.GT_OR_EQ), _configSchema.schema.literal(Comparator.LT), _configSchema.schema.literal(Comparator.LT_OR_EQ), _configSchema.schema.literal(Comparator.EQ), _configSchema.schema.literal(Comparator.NOT_EQ), _configSchema.schema.literal(Comparator.MATCH), _configSchema.schema.literal(Comparator.NOT_MATCH), _configSchema.schema.literal(Comparator.MATCH_PHRASE), _configSchema.schema.literal(Comparator.NOT_MATCH_PHRASE)]);
const ThresholdSchema = _configSchema.schema.object({
  comparator: ComparatorSchema,
  value: _configSchema.schema.number()
}, {
  unknowns: 'ignore'
});
const criterionSchema = _configSchema.schema.object({
  field: _configSchema.schema.string(),
  comparator: ComparatorSchema,
  value: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()])
}, {
  unknowns: 'ignore'
});
const countCriteriaSchema = _configSchema.schema.arrayOf(criterionSchema);
const ratioCriteriaSchema = _configSchema.schema.arrayOf(countCriteriaSchema);
const timeUnitSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('s'), _configSchema.schema.literal('m'), _configSchema.schema.literal('h'), _configSchema.schema.literal('d')]);
const timeSizeSchema = _configSchema.schema.number();
const groupBySchema = _configSchema.schema.arrayOf(_configSchema.schema.string());
const countRuleParamsSchema = _configSchema.schema.object({
  criteria: countCriteriaSchema,
  // NOTE: "count" would be better named as "threshold", but this would require a
  // migration of encrypted saved objects, so we'll keep "count" until it's problematic.
  count: ThresholdSchema,
  timeUnit: timeUnitSchema,
  timeSize: timeSizeSchema,
  logView: persistedLogViewReferenceSchema,
  // Alerts are only compatible with persisted Log Views
  groupBy: _configSchema.schema.maybe(groupBySchema)
}, {
  unknowns: 'ignore'
});
const ratioRuleParamsSchema = _configSchema.schema.object({
  criteria: ratioCriteriaSchema,
  // NOTE: "count" would be better named as "threshold", but this would require a
  // migration of encrypted saved objects, so we'll keep "count" until it's problematic.
  count: ThresholdSchema,
  timeUnit: timeUnitSchema,
  timeSize: timeSizeSchema,
  logView: persistedLogViewReferenceSchema,
  // Alerts are only compatible with persisted Log Views
  groupBy: _configSchema.schema.maybe(groupBySchema)
}, {
  unknowns: 'ignore'
});
const logThresholdParamsSchema = exports.logThresholdParamsSchema = _configSchema.schema.oneOf([countRuleParamsSchema, ratioRuleParamsSchema]);

// Export types for TypeScript