"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricInventoryThresholdRuleParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _alertingComparators = require("@kbn/alerting-comparators");
var _utils = require("../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SNAPSHOT_CUSTOM_AGGREGATIONS = ['avg', 'max', 'min', 'rate'];
const dataSchemaFormats = ['ecs', 'semconv'];
const SnapshotMetricTypeKeysArray = ['count', 'cpuV2', 'cpu', 'diskSpaceUsage', 'load', 'memory', 'memoryFree', 'normalizedLoad1m', 'tx', 'rx', 'txV2', 'rxV2', 'logRate', 'diskIOReadBytes', 'diskIOWriteBytes', 's3TotalRequests', 's3NumberOfObjects', 's3BucketSize', 's3DownloadBytes', 's3UploadBytes', 'rdsConnections', 'rdsQueriesExecuted', 'rdsActiveTransactions', 'rdsLatency', 'sqsMessagesVisible', 'sqsMessagesDelayed', 'sqsMessagesSent', 'sqsMessagesEmpty', 'sqsOldestMessage', 'custom'];
const comparators = Object.values({
  ..._alertingComparators.COMPARATORS,
  ..._utils.LEGACY_COMPARATORS
});
const metricInventoryThresholdRuleParamsSchema = exports.metricInventoryThresholdRuleParamsSchema = _configSchema.schema.object({
  criteria: _configSchema.schema.arrayOf(_configSchema.schema.object({
    threshold: _configSchema.schema.arrayOf(_configSchema.schema.number()),
    comparator: (0, _utils.oneOfLiterals)(comparators),
    timeUnit: _configSchema.schema.string(),
    timeSize: _configSchema.schema.number(),
    metric: (0, _utils.oneOfLiterals)(SnapshotMetricTypeKeysArray),
    warningThreshold: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number())),
    warningComparator: _configSchema.schema.maybe((0, _utils.oneOfLiterals)(comparators)),
    customMetric: _configSchema.schema.maybe(_configSchema.schema.object({
      type: _configSchema.schema.literal('custom'),
      id: _configSchema.schema.string(),
      field: _configSchema.schema.string(),
      aggregation: (0, _utils.oneOfLiterals)(SNAPSHOT_CUSTOM_AGGREGATIONS),
      label: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  })),
  nodeType: _configSchema.schema.string(),
  filterQuery: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: _utils.validateIsStringElasticsearchJSONFilter
  })),
  sourceId: _configSchema.schema.string(),
  alertOnNoData: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  schema: _configSchema.schema.maybe((0, _utils.oneOfLiterals)(dataSchemaFormats))
}, {
  unknowns: 'allow'
});